function sum = trapz(ssm, de)
%TRAPZ Calculate the area under the trajectory of a DynamicElement belonging to a StateSpaceModel
%
% Usage:
%   trapz(ssm,de)
%   ssm.trapz(de)
%
% This function is similar to trapz(de), but is useful if de has no val field 
% calculated, but rather a def field that depends on other elements in ssm, 
% that do have a val field calculated

% David Katzin, Wageningen University
% david.katzin@wur.nl

        x = ssm.x; u = ssm.u; d = ssm.d; a = ssm.a; p = ssm.p;
        sum = trapz(eval(de.def));
end

